/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import filenet.vw.base.logging.Logger;
import filenet.vw.server.VWCapsule;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class VWCallbackHandler
implements CallbackHandler {
    protected String username = null;
    protected String password = null;
    protected static Logger logger = Logger.getLogger("filenet.vw.LoginModule");
    private static String WSCredTokenCallbackImpl = "com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl";

    public VWCallbackHandler(String username, String password) {
        logger.entering("VWCallbackHandler", "<init>");
        if (logger.isFinest()) {
            logger.finest("VWCallbackHandler", "<init>", "username:  " + username);
        }
        this.username = username;
        this.password = password;
        logger.exiting("VWCallbackHandler", "<init>");
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        logger.entering("VWCallbackHandler", "handle");
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                nc.setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                try {
                    VWCapsule capsule = new VWCapsule();
                    capsule.setString(this.password);
                    this.password = capsule.getString();
                    pc.setPassword(this.password.toCharArray());
                }
                catch (Exception e) {}
                continue;
            }
            if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                if (toc.getMessageType() == 2) {
                    logger.fine("ERROR: " + toc.getMessage());
                    continue;
                }
                if (toc.getMessageType() == 1) {
                    logger.fine("WARNING: " + toc.getMessage());
                    continue;
                }
                if (!logger.isFinest()) continue;
                logger.finest("INFORMATION: " + toc.getMessage());
                continue;
            }
            if (callbacks[i].getClass().getName().equals(WSCredTokenCallbackImpl)) {
                if (!logger.isFinest()) continue;
                logger.finest("VWCallbackhandler", "handle", "GOT :" + WSCredTokenCallbackImpl);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
        logger.exiting("VWCallbackHandler", "handle");
    }
}

